/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.item;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.brackets.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.JSONConverter;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.IngredientConverter;
import com.blamejared.crafttweaker.api.item.conditions.IIngredientCondition;
import com.blamejared.crafttweaker.api.item.tooltip.ITooltipFunction;
import com.blamejared.crafttweaker.impl.actions.items.ActionModifyAttribute;
import com.blamejared.crafttweaker.impl.actions.items.ActionSetBurnTime;
import com.blamejared.crafttweaker.impl.actions.items.tooltips.ActionAddShiftedTooltip;
import com.blamejared.crafttweaker.impl.actions.items.tooltips.ActionAddTooltip;
import com.blamejared.crafttweaker.impl.actions.items.tooltips.ActionClearTooltip;
import com.blamejared.crafttweaker.impl.actions.items.tooltips.ActionModifyShiftedTooltip;
import com.blamejared.crafttweaker.impl.actions.items.tooltips.ActionModifyTooltip;
import com.blamejared.crafttweaker.impl.actions.items.tooltips.ActionRemoveRegexTooltip;
import com.blamejared.crafttweaker.impl.data.MapData;
import com.blamejared.crafttweaker.impl.ingredients.conditions.ConditionAnyDamage;
import com.blamejared.crafttweaker.impl.ingredients.conditions.ConditionCustom;
import com.blamejared.crafttweaker.impl.ingredients.conditions.ConditionDamaged;
import com.blamejared.crafttweaker.impl.item.MCIngredientList;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker.impl.item.conditions.MCIngredientConditioned;
import com.blamejared.crafttweaker.impl.util.text.MCTextComponent;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.ZenWrapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.ForgeHooks;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.item.IIngredient")
@Document(value="vanilla/api/items/IIngredient")
@ZenWrapper(wrappedClass="net.minecraft.item.crafting.Ingredient", conversionMethodFormat="%s.asVanillaIngredient()", displayStringFormat="%.getCommandString()")
public interface IIngredient
extends CommandStringDisplayable {
    @ZenCodeType.Method
    default public boolean matches(IItemStack stack) {
        return this.matches(stack, false);
    }

    @ZenCodeType.Method
    public boolean matches(IItemStack var1, boolean var2);

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CONTAINS)
    default public boolean contains(IIngredient ingredient) {
        return Arrays.stream(ingredient.getItems()).allMatch(this::matches);
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public Ingredient asVanillaIngredient();

    @ZenCodeType.Method
    default public IItemStack getRemainingItem(IItemStack stack) {
        return new MCItemStack(ForgeHooks.getContainerItem((ItemStack)stack.getInternal()));
    }

    @Override
    @ZenCodeType.Getter(value="commandString")
    public String getCommandString();

    @ZenCodeType.Getter(value="items")
    public IItemStack[] getItems();

    @ZenCodeType.Method
    default public MCIngredientConditioned<IIngredient> onlyDamaged() {
        return new MCIngredientConditioned<IIngredient>(this, new ConditionDamaged());
    }

    @ZenCodeType.Method
    default public MCIngredientConditioned<IIngredient> anyDamage() {
        return new MCIngredientConditioned<IIngredient>(this, new ConditionAnyDamage());
    }

    @ZenCodeType.Method
    default public MCIngredientConditioned<IIngredient> onlyIf(String uid, @ZenCodeType.Optional Predicate<IItemStack> function) {
        return new MCIngredientConditioned<IIngredient>(this, new ConditionCustom(uid, function));
    }

    @ZenCodeType.Method
    default public MCIngredientConditioned<IIngredient> only(IIngredientCondition<IIngredient> condition) {
        return new MCIngredientConditioned<IIngredient>(this, condition);
    }

    @ZenCodeType.Setter(value="burnTime")
    default public void setBurnTime(int time) {
        CraftTweakerAPI.apply(new ActionSetBurnTime(this, time));
    }

    @ZenCodeType.Method
    default public void clearTooltip() {
        CraftTweakerAPI.apply(new ActionClearTooltip(this));
    }

    @ZenCodeType.Method
    default public void addTooltip(MCTextComponent content) {
        CraftTweakerAPI.apply(new ActionAddTooltip(this, content));
    }

    @ZenCodeType.Method
    default public void addShiftTooltip(MCTextComponent content, @ZenCodeType.Optional MCTextComponent showMessage) {
        CraftTweakerAPI.apply(new ActionAddShiftedTooltip(this, content, showMessage));
    }

    @ZenCodeType.Method
    default public void modifyTooltip(ITooltipFunction function) {
        CraftTweakerAPI.apply(new ActionModifyTooltip(this, function));
    }

    @ZenCodeType.Method
    default public void modifyShiftTooltip(ITooltipFunction shiftedFunction, @ZenCodeType.Optional ITooltipFunction unshiftedFunction) {
        CraftTweakerAPI.apply(new ActionModifyShiftedTooltip(this, shiftedFunction, unshiftedFunction));
    }

    @ZenCodeType.Method
    default public void removeTooltip(String regex) {
        CraftTweakerAPI.apply(new ActionRemoveRegexTooltip(this, Pattern.compile(regex)));
    }

    @ZenCodeType.Method
    default public void addGlobalAttributeModifier(Attribute attribute, String name, double value, AttributeModifier.Operation operation, EquipmentSlotType[] slotTypes) {
        AttributeModifier modifier = new AttributeModifier(name, value, operation);
        HashSet<EquipmentSlotType> validSlots = new HashSet<EquipmentSlotType>(Arrays.asList(slotTypes));
        CraftTweakerAPI.apply(new ActionModifyAttribute(this, event -> {
            if (validSlots.contains(event.getSlotType())) {
                if (event.getModifiers().containsEntry((Object)attribute, (Object)modifier)) {
                    event.removeModifier(attribute, modifier);
                }
                event.addModifier(attribute, modifier);
            }
        }));
    }

    @ZenCodeType.Method
    default public void addGlobalAttributeModifier(Attribute attribute, String uuid, String name, double value, AttributeModifier.Operation operation, EquipmentSlotType[] slotTypes) {
        AttributeModifier modifier = new AttributeModifier(UUID.fromString(uuid), name, value, operation);
        HashSet<EquipmentSlotType> validSlots = new HashSet<EquipmentSlotType>(Arrays.asList(slotTypes));
        CraftTweakerAPI.apply(new ActionModifyAttribute(this, event -> {
            if (validSlots.contains(event.getSlotType())) {
                if (event.getModifiers().containsEntry((Object)attribute, (Object)modifier)) {
                    event.removeModifier(attribute, modifier);
                }
                event.addModifier(attribute, modifier);
            }
        }));
    }

    @ZenCodeType.Method
    default public void removeGlobalAttribute(Attribute attribute, EquipmentSlotType[] slotTypes) {
        HashSet<EquipmentSlotType> validSlots = new HashSet<EquipmentSlotType>(Arrays.asList(slotTypes));
        CraftTweakerAPI.apply(new ActionModifyAttribute(this, event -> {
            if (validSlots.contains(event.getSlotType())) {
                event.removeAttribute(attribute);
            }
        }));
    }

    @ZenCodeType.Method
    default public void removeGlobalAttributeModifier(String uuid, EquipmentSlotType[] slotTypes) {
        HashSet<EquipmentSlotType> validSlots = new HashSet<EquipmentSlotType>(Arrays.asList(slotTypes));
        CraftTweakerAPI.apply(new ActionModifyAttribute(this, event -> {
            if (validSlots.contains(event.getSlotType())) {
                event.getModifiers().entries().stream().filter(entry -> ((AttributeModifier)entry.getValue()).func_111167_a().equals(UUID.fromString(uuid))).forEach(entry -> event.removeModifier((Attribute)entry.getKey(), (AttributeModifier)entry.getValue()));
            }
        }));
    }

    public static IIngredient fromIngredient(Ingredient ingredient) {
        return IngredientConverter.fromIngredient(ingredient);
    }

    @ZenCodeType.Caster(implicit=true)
    default public MapData asMapData() {
        IData data = this.asIData();
        return data instanceof MapData ? (MapData)data : new MapData();
    }

    @ZenCodeType.Caster(implicit=true)
    default public IData asIData() {
        return JSONConverter.convert(this.asVanillaIngredient().func_200304_c());
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    default public MCIngredientList or(IIngredient other) {
        return new MCIngredientList(new IIngredient[]{this, other});
    }
}

